IF OBJECT_ID('V_PARCIAL_TOP_PRODUTOS') IS NOT NULL
	DROP VIEW V_PARCIAL_TOP_PRODUTOS
GO
CREATE VIEW V_PARCIAL_TOP_PRODUTOS
AS
SELECT	TOP 10 *
FROM
(
SELECT	
        P.CD_EMP,P.CD_PROD AS CODIGO,P.DS_PROD AS DESCRICAO,COUNT(0) AS QTDE,SUM(TOT_IT) AS TOTAL,ROUND(SUM(TOT_IT) / COUNT(0),2) AS TICKET
FROM    PDV_VD V
INNER   JOIN PDV_VD_IT I 
ON	V.CD_EMP = I.CD_EMP AND V.CD_FILIAL = I.CD_FILIAL AND V.CD_VD = I.CD_VD AND V.DT_VD = I.DT_VD
INNER   JOIN EST_PROD P 
ON      I.CD_EMP = P.CD_EMP AND I.CD_PROD = P.CD_PROD
WHERE   V.DT_VD = CONVERT(VARCHAR,GETDATE(),112) AND V.ST_VD = 0 AND I.ST_IT = 1
GROUP   BY P.CD_EMP,P.CD_PROD,P.DS_PROD
UNION	
SELECT	CD_EMP,0 AS CD_PROD,'RECARGA' AS DS_PROD,COUNT(0) AS QTDE,SUM(VLR_TOT_CUPOM) AS TOTAL,ROUND(SUM(VLR_TOT_CUPOM) / COUNT(0),2) AS TICKET
FROM	PDV_CUPOM_NAO_FISCAL
WHERE	DT_CUPOM = CONVERT(VARCHAR,GETDATE(),112) AND TP_CUPOM_NAO_FISCAL = 3
GROUP   BY CD_EMP
)	TMP
ORDER	BY TOTAL DESC